/*---------------------------------------------------------------------------*\

    FILE....: APIFUNC.H
    TYPE....: C++ Header File
    AUTHOR..: David Rowe
    DATE....: 4/2/98

    Header file for help functions used to implement API.  These functions
    are not exposed to the applications programmer.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __APIFUNC__
#define __APIFUNC__

#include "contypes.h"
#include "comm.h"
#include "fifo.h"
#include "vpbapi.h"
#include "wobbly.h"
#include "vpbtimer.h"

/*---------------------------------------------------------------------------*\

				  DEFINES
							
\*---------------------------------------------------------------------------*/

// device handle flags

#define	VPB_OFF	0
#define	VPB_ON	1

// VPB models

#define	VPB4	0		// 4 channel voice processing board
#define	VPB8L	1		// 8 channel voice logging board

/*---------------------------------------------------------------------------*\

			      TYPEDEFS
							
\*---------------------------------------------------------------------------*/

// This structure stores information needed for each device.  An array of
// this structure of length Totalchns is created at initialisation

typedef struct {

	int  DevHndles;		// array of device handles enable flags.
				// index of array is device handle. 
				// if DevHndles[handle] asserted handle 
				// is enabled (allocated)
							
	USHORT Chnevtmsk;	// stores current event mask

	void (WINAPI *event_callback)(VPB_EVENT *e, void *context);	
				// optional event callback for each channel
	void *context;		// context info for event callback

	Fifo *APIQ;		// ptr to API event Q object for each channel
} VPB_DEV;

/*-------------------------------------------------------------------------*\

				 GLOBALS

\*-------------------------------------------------------------------------*/

extern VPB_DEV		 *vpb_dev;	// array of device information
extern Comm		 *vpb_c;	// ptr to comm object
extern int		 model;		// which platform we are using

/*-------------------------------------------------------------------------*\

			    FUNCTION HEADERS

\*-------------------------------------------------------------------------*/

void CheckNew(void *p);
int RunTimeError(Wobbly w, char api_function[]);
void ValidHandleCheck(int devhandle);
int putevt(VPB_EVENT *e, USHORT mask);
void apifunc_trace(char s[]);

#endif	/* #ifndef __APIFUNC__	*/
